@extends('layouts.vendor-template')

@section('content')

        <!-- Main Section start -->
        <main>
            
                <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12 ">
                <h4 class="main-title">{{$data->title}} : Booking ID- {{$data->booking_id}}
                     <a href="#" class="position-relative bg-light-primary px-2 py-1 b-r-10">
                                   <i class="ph-fill  ph-download"></i> Invoice
                                    <span class="position-absolute top-0 start-100 translate-middle p-1 bg-primary rounded-circle animate__animated animate__fadeIn animate__infinite animate__fast"></span>
                                </a>
                </h4>
               
                     <div class="row mb-3">
                       <div class="col-md-4 mt-2 d-flex align-items-center gap-2">
                           <p class="f-w-600 mb-0">Overall Rating: </p>:
                              <div class="rating ">
                                    @for($i=1;$i<=$data->overall_review_rate;$i++)
                                   <input type="radio" id="star15" name="ratings2" value="15" checked="" disabled="">
                                    <label class="star" for="star15"><span class="ti ti-star-filled f-s-20 text-warning"></span></label>
                                    @endfor
                                     @for($i=1;$i<=5-$data->overall_review_rate;$i++)
                                   <input type="radio" id="star14" name="ratings2" value="14" disabled="">
                                    <label class="star" for="star14"><span class="ti ti-star f-s-20 text-warning"></span></label>
                                    @endfor
                                  
                                </div>
                                <div>
                             </div>
                         </div>
    
                          <div class="col-md-4 mt-2 d-flex align-items-center gap-2">
                           <p class="f-w-600 mb-0">Driver Rating:: </p>:
                              <div class="rating ">
                                    @for($i=1;$i<=$data->driver_rating;$i++)
                                   <input type="radio" id="star15" name="ratings2" value="15" checked="" disabled="">
                                    <label class="star" for="star15"><span class="ti ti-star-filled f-s-20 text-warning"></span></label>
                                    @endfor
                                     @for($i=1;$i<=5-$data->driver_rating;$i++)
                                   <input type="radio" id="star14" name="ratings2" value="14" disabled="">
                                    <label class="star" for="star14"><span class="ti ti-star f-s-20 text-warning"></span></label>
                                    @endfor
                                  
                                </div>
                                <div>
                             </div>
                         </div>

                         <div class="col-md-4 mt-2 d-flex align-items-center gap-2 text-end">
                           <p class="f-w-600 mb-0">Cab Rating:: </p>:
                               <div class="rating ">
                                    @for($i=1;$i<=$data->car_rating;$i++)
                                   <input type="radio" id="star15" name="ratings2" value="15" checked="" disabled="">
                                    <label class="star" for="star15"><span class="ti ti-star-filled f-s-20 text-warning"></span></label>
                                    @endfor
                                     @for($i=1;$i<=5-$data->car_rating;$i++)
                                   <input type="radio" id="star14" name="ratings2" value="14" disabled="">
                                    <label class="star" for="star14"><span class="ti ti-star f-s-20 text-warning"></span></label>
                                    @endfor
                                <div>
                             </div>
                         </div>

                       
                </div>
                       

            </div>
        </div>
        <!-- Breadcrumb end -->
 <!-- Project Details start -->
        <div class="row">
            <div class="col-md-6 col-xxl-4 order-md-2 order-xxl-1">
                <!-- Project Details -->
                <div class="card">
                    <div class="card-header">
                        <h5>User Details</h5>
                    </div>
                    <div class="card-body">
                        <table class=" project-details-table table table-borderless  align-middle mb-0">
                            <tbody>
                            <tr>
                                <td>
                                    <p class="f-w-600 mb-0">Vooked By</p>
                                </td>
                                <td class="text-end">
                                   {{$data->role}}
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <p class="f-w-600 mb-0">Client Name:</p>
                                </td>
                                <td class="text-end">
                                    {{$data->client_name}}
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <p class="f-w-600 mb-0">Client Mobile Number: </p>
                                </td>
                                <td class="text-end"><span class="text-primary">{{$data->client_mobile_number}}</span>
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    <p class="f-w-600 mb-0">Client Email</p>
                                </td>
                                <td class="text-end"><span class="text-danger">{{$data->client_email}}</span>
                                </td>
                            </tr>
                          
                            </tbody>
                        </table>
                    </div>
                </div>
                <!--end  Project Details -->

                <!-- Project Team -->

                <div class="card ">
                    <div class="card-header">
                        <h5 class="header-title-text">Agency Details</h5>
                    </div>
                    <div class="card-body">
                        <table class=" project-details-table table table-borderless  align-middle mb-0">
                            <tbody>
                            <tr>
                                <td>
                                    <p class="f-w-600 mb-0">Vendor : </p>
                                </td>
                                <td class="text-end">
                                  <a href="{{route('vendor.profile')}}">
                                    <img src=" {{$data->cab_agency_details->vendor_image}}" alt="" class="img-fluid h-35 w-35">
                                 </a>
                                </td>
                                <td class="text-end">
                                  <a href="{{route('vendor.profile')}}">
                                  {{$data->cab_agency_details->vendor_name}}
                                </a>
                                </td>
                            </tr>
                            @if($driver!=null)
                            <tr>
                                <td>
                                    <p class="f-w-600 mb-0">Driver :</p>
                                </td>
                                <td class="text-end">
                                       
                                 <a href="{{route('vendor.edit-driver',['id'=>$data->driver_id])}}">
                                    <img src=" {{$driver->image}}" alt="" class="img-fluid h-35 w-35">
                                 </a>
                                </td>
                                <td class="text-end">
                                 <a href="{{route('vendor.edit-driver',['id'=>$data->driver_id])}}">
                                   {{$driver->name}}
                                </a>
                                </td>
                            </tr>
                            @endif
                            <tr>
                                <td>
                                    <p class="f-w-600 mb-0">Cab Model: </p>
                                </td>
                                
                                    <td class="text-end">
                                    
                                    <ul class="avatar-group justify-content-end">
                                            @for($i=0;$i<count($data->cab_agency_details->image);$i++)
                                        <li class="text-bg-danger h-30 w-30 d-flex-center b-r-50"
                                            >
                                             <img src=" {{$data->cab_agency_details->image[$i]}}" alt="" class="img-fluid h-35 w-35">
                                        </li>
                                        @endfor
                                       
                                    </ul>
                                </td>
                                <td class="text-end"><span class="text-primary"> 
                                    {{$data->cab_agency_details->model}}</span>
                                </td>
                            </tr>

                              <tr>
                                <td>
                                    <p class="f-w-600 mb-0">Review Comment:</p>
                                </td>
                                <td class="text-end">
                                    {{$data->comment}}
                                </td>
                            </tr>
                     
                            </tbody>
                        </table>
                    </div>
                </div>
                <!--end Project Team -->

            </div>
            <div class="col-xxl-5 order-xxl-2">
                <!-- project activity -->
                <div class="card">
                    <div class="card-header">
                        <h5> Trip Location Details</h5>
                    </div>
                    <div class="card-body">
                        <ul class="app-timeline-box">
                            <li class="timeline-section">
                                <div class="timeline-icon">
                                             <span class="text-light-success h-35 w-35 d-flex-center b-r-50">
                                             <i class="ph-bold ph-map-pin"></i>
                                             </span>
                                </div>
                                <div class="timeline-content pt-0 ">
                                    <div class="d-flex f-s-16">
                                        <p class="text-success f-s-16 mb-0">{{$data->pick_up}}</p>
                                     </div>
                                    <p class="">
                                     {{$data->departure_date}}  {{$data->departure_time}}
                                    </p>
                                </div>
                            </li>
                            <li class="timeline-section">
                                <div class="timeline-icon">
                                             <span class="text-light-danger h-35 w-35 d-flex-center b-r-50">
                                             <i class="ph-bold ph-map-pin"></i>
                                             </span>
                                </div>
                                <div class="timeline-content pt-0 ">
                                    <div class="d-flex f-s-16">
                                        <p class="text-danger f-s-16 mb-0">{{$data->drop_off}}</p>
                                       
                                    </div>
                                    <p class="">
                                     {{$data->return_date}}  {{$data->return_time}}
                                    </p>
                                </div>
                            </li>
                        
                        </ul>

                          <div class="card-header">
                                <h5> Stay/Days Details</h5>
                          </div>
                            <ul class="app-timeline-box">
                          @for($i=0;$i< count($data->stay_date);$i++)
               
                            <li class="timeline-section">
                                <div class="timeline-icon">
                                             <span class="text-light-warning h-35 w-35 d-flex-center b-r-50">
                                             <i class="ph-bold ph-map-pin"></i>
                                             </span>
                                </div>
                                <div class="timeline-content pt-0 ">
                                    <div class="d-flex f-s-16">
                                        <p class="text-warning f-s-16 mb-0">Day {{$i+1}} : {{$data->stay_date[$i]}}</p>
                                     </div>
                                    <p class="">
                                    {{$data->stay_locations[$i]}}
                                    </p>
                                </div>
                            </li>
                            @endfor
                        
                        </ul>

                    </div>
            </div>
 
                <!-- end project activity -->
            </div>
            <div class="col-md-6 col-xxl-3 order-md-1 order-xxl-3">
                <!-- About project -->
                <div class="card">
                    <div class="card-header">
                        <h5>Trip Detailes</h5>
                    </div>
                    <div class="card-body">
                     <table class=" project-details-table table table-borderless  align-middle mb-0">
                            <tbody>
                            <tr>
                                <td>
                                    <p class="f-w-600 mb-0">Total KM</p>
                                </td>
                                <td class="text-end">
                                   {{$data->total_km}}
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <p class="f-w-600 mb-0">Adults:</p>
                                </td>
                                <td class="text-end">
                                    {{$data->adults}}
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <p class="f-w-600 mb-0">children: </p>
                                </td>
                                <td class="text-end"><span class="text-primary">{{$data->children}}</span>
                                </td>
                            </tr>
                            @if($data->role=='Partner')
                            <tr>
                                <td>
                                    <p class="f-w-600 mb-0">commission Rate</p>
                                </td>
                                <td class="text-end">{{$data->commission_rate}}
                                </td>
                            </tr>
                            @endif
                            <tr>
                                <td class="pb-0">
                                    <p class="f-w-600 mb-0">Tax</p>
                                </td>
                                <td class="text-end pb-0">
                                    <h6>{{$data->tax }}</h6>
                                </td>
                            </tr>
                             <tr>
                                <td class="pb-0">
                                    <p class="f-w-600 mb-0">total_fare</p>
                                </td>
                                <td class="text-end pb-0">
                                    <h6>{{$data->total_fare }}</h6>
                                </td>
                            </tr>
                             <tr>
                                <td class="pb-0">
                                    <p class="f-w-600 mb-0">Platform Fee</p>
                                </td>
                                <td class="text-end pb-0">
                                    <h6>{{$data->platform_fee }}</h6>
                                </td>
                            </tr>
                             <tr>
                                <td class="pb-0">
                                    <p class="f-w-600 mb-0">Paid Amount</p>
                                </td>
                                <td class="text-end pb-0">
                                    <h6><span class="text-danger">{{$data->paid_amount }}</span></h6>
                                </td>
                            </tr>
                             <tr>
                                <td class="pb-0">
                                    <p class="f-w-600 mb-0">Booking Status</p>
                                </td>
                                <td class="text-end pb-0">
                                    <h6>{{$data->booking_status }}</h6>
                                </td>
                            </tr>
                             <tr>
                                <td class="pb-0">
                                    <p class="f-w-600 mb-0">Payment Status</p>
                                </td>
                                <td class="text-end pb-0">
                                    <h6>{{$data->payment_status }}</h6>
                                </td>
                            </tr>
                          
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- about project end  -->
              
            </div>
        </div>
        <!-- Project Details end -->
    </div>
        </main>
      
      <div class="modal fade" id="brand" tabindex="-1" aria-labelledby="exampleModalLabel"
                             aria-hidden="true">
                             <form action="{{route('vendor.assign-driver')}}" method="post">
                                @csrf
                                    <div class="modal-dialog modal-dialog-centered" id="staticBackdrop">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h1 class="modal-title f-w-500 fs-5" id="exampleModalLabel1">Assign Driver</h1>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body app-form">
                                               
                                                <div class="mb-3" id="newtask">
                                                    <label class="form-label">Select Driver</label>
                                                    <input type="hidden" value="{{$data->id}}" name="booking_id">
                                                    <select class="form-control todo-inputs" name="driver_id"  >
                                                        @foreach(App\Models\Driver::where('vendor_id',Auth::guard('vendor-web')->user()->id)->get() as $item)
                                                        <option value="{{$item->id}}" {{ $data->driver_id == $item->id ? 'selected' : '' }}>{{$item->name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>

                                                     <div class="filebox mt-3" id="newtask">
                                                       <p class=" f-s-16 text-danger mb-0">Note: When a vendor is assigned, the booking status automatically changes to “Confirmed.” </p>
                                                    </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button class="btn btn-primary" type="submit" id="push"
                                                        data-bs-dismiss="modal">Save changes</button>
                                            </div>
                                        </div>
                                    </div>
                            </form>
                     </div>
  @endsection
